var ContactListItem = new Class({
  owner: null,
  info: null,
	open: false,
	options: {
    class_name: "contact_list_item",
    id_prefix: "contact_list_item_"
  },
	
	initialize: function(o, info, open){
		this.owner = o;
		this.info = new Hash();
		this.load(info);
		this.open = open;
		
		var tpl = new Template("contact_list_item");
    this.el = new Element('div').adopt(tpl.xml).getFirst();
		
		if (this.open) {
			this.el.getElement('.body').removeClass('hidden');
		} else {
			this.el.getElement('.body').addClass('hidden');
		}
		
		var t = this;
		this.el.getElement('a.remove').addEvent('click', function(){
			t.owner.user.removeContact(t.info.id);
		});
		
		this.el.getElement('a.history').addEvent('click', function(){		
			if (t.owner.user.info.anonymous) {
				alert('Neregistrovaní používatelia nemôžu zobrazovať históriu konverzácií.');
				return;
	  	}
			t.owner.user.showContactHistory(t.info.id);
		});			
		
		this.el.getElement('a.cprofile').addEvent('click', function(){
			t.owner.user.showContactProfile(t.info.id);
		});
		
		this.el.getElement('.header').addEvent('click', function(){
      var b = t.el.getElement('.body');
			if(!t.open){
				b.removeClass('hidden');
			} else {
				b.addClass('hidden');
			}		
			t.open = !t.open;
    });
		
		this.el.getElement('.header').addEvent('dblclick', function(e){
			t.owner.user.startConversation(t.info.id);
    });
	},
	
	load: function(info){
		this.info = info;
		return this;
	},
	
	setContentEls: function(){
		var t = this;
		
		$each(this.info, function(value, key){
			var el = t.el.getElement('.'+key);			
			if($defined(el)) el.set('text', value);
			
			if($defined(el) && (key == 'email')){
				el.getParent().setProperty('href', 'mailto:'+value);
			}
		});
		
		// update status
		this.el.getElement('.status').set('text', '').removeClass('offline').removeClass('online').addClass((this.info.status) ? 'online' : 'offline');
	},
	
	getEl: function(){
		this.setContentEls();
		return this.el.setProperty('id', this.options.id_prefix + this.info.id);
	}
});

ContactListItem.implement(new Options);